# POS System - Complete Setup Guide

## Overview
This is a complete Point of Sale (POS) system built with Node.js, Express, React, and SQLite. The system includes inventory management, sales processing, agent tracking, payment management, and comprehensive reporting.

## Prerequisites

### 1. Install Node.js and npm
- Download Node.js from: https://nodejs.org/
- Choose the LTS (Long Term Support) version
- This will also install npm (Node Package Manager)
- Verify installation by opening Command Prompt and running:
  ```
  node --version
  npm --version
  ```

## Quick Start

### Option 1: Automatic Setup (Recommended)
1. Double-click `start-pos-system.bat` to automatically install dependencies and start both servers
2. Wait for both servers to start (backend on port 5000, frontend on port 3000)
3. Open your browser and go to: http://localhost:3000

### Option 2: Manual Setup

#### Step 1: Install Backend Dependencies
```bash
cd backend
npm install
```

#### Step 2: Install Frontend Dependencies
```bash
cd ../frontend
npm install
```

#### Step 3: Start Backend Server
```bash
cd ../backend
npm start
```
The backend will run on: http://localhost:5000

#### Step 4: Start Frontend Server (in a new terminal)
```bash
cd frontend
npm start
```
The frontend will run on: http://localhost:3000

## Default Login Credentials
- **Username:** admin
- **Password:** admin123

## System Features

### 🏪 Core POS Features
- **Product Management**: Add, edit, delete products with categories
- **Inventory Tracking**: Real-time stock levels and low stock alerts
- **Sales Processing**: Complete checkout system with receipt generation
- **Payment Methods**: Cash, Bank Transfer, Mobile Payment support

### 👥 User Management
- **Authentication**: Secure login system with JWT tokens
- **Role-based Access**: Admin and Agent roles with different permissions
- **Agent Management**: Track agent performance and commissions

### 💰 Financial Management
- **Payment Tracking**: Record all payments and receipts
- **Agent Balances**: Track agent earnings and balances
- **Financial Reports**: Comprehensive reporting system

### 📊 Reports & Analytics
- **Sales Dashboard**: Visual charts and metrics
- **Inventory Reports**: Stock levels and movement
- **Agent Performance**: Individual agent statistics
- **Financial Summary**: Revenue and payment analysis

## Project Structure

```
pos-system/
├── backend/                 # Node.js/Express API
│   ├── config/             # Database configuration
│   ├── controllers/        # Business logic
│   ├── middleware/         # Authentication & validation
│   ├── models/            # Database models (Sequelize)
│   ├── routes/            # API endpoints
│   ├── server.js          # Main server file
│   └── package.json       # Backend dependencies
├── frontend/               # React application
│   ├── src/
│   │   ├── components/    # Reusable components
│   │   ├── pages/         # Main application pages
│   │   ├── context/       # React context for state
│   │   └── App.js         # Main React component
│   └── package.json       # Frontend dependencies
├── dashboard.html          # Static demo dashboard
└── README.md              # This file
```

## API Endpoints

### Authentication
- `POST /api/auth/login` - User login
- `POST /api/auth/register` - User registration

### Products
- `GET /api/products` - Get all products
- `POST /api/products` - Create new product
- `PUT /api/products/:id` - Update product
- `DELETE /api/products/:id` - Delete product

### Categories
- `GET /api/categories` - Get all categories
- `POST /api/categories` - Create new category

### Inventory
- `GET /api/inventory` - Get inventory status
- `POST /api/inventory/adjust` - Adjust stock levels

### Sales
- `GET /api/sales` - Get sales history
- `POST /api/sales` - Process new sale

### Agents
- `GET /api/agents` - Get all agents
- `POST /api/agents` - Create new agent
- `GET /api/agents/:id/balance` - Get agent balance

### Reports
- `GET /api/reports/sales-summary` - Sales summary
- `GET /api/reports/top-products` - Top selling products
- `GET /api/reports/inventory-status` - Inventory status
- `GET /api/reports/agent-performance` - Agent performance

## Database

The system uses SQLite database which is automatically created when you first run the backend. The database file (`database.sqlite`) will be created in the backend directory.

### Default Data
- Admin user is automatically created on first run
- Sample categories and products can be added through the interface

## Troubleshooting

### Common Issues

1. **Port already in use**
   - Backend (5000): Change PORT in backend/.env
   - Frontend (3000): React will automatically suggest an alternative port

2. **Database connection issues**
   - Delete `database.sqlite` file and restart backend to recreate

3. **npm install fails**
   - Clear npm cache: `npm cache clean --force`
   - Delete `node_modules` folder and run `npm install` again

4. **CORS errors**
   - Ensure backend is running on port 5000
   - Check that frontend is configured to proxy to correct backend URL

### Getting Help
- Check the browser console for frontend errors
- Check the terminal/command prompt for backend errors
- Ensure all dependencies are installed correctly

## Development

### Adding New Features
1. Backend: Add routes in `routes/`, controllers in `controllers/`, models in `models/`
2. Frontend: Add components in `src/components/`, pages in `src/pages/`
3. Update this README with new features

### Testing
- Backend tests: `npm test` (in backend directory)
- Frontend tests: `npm test` (in frontend directory)

## License
This project is for educational and commercial use.

## Support
For technical support or feature requests, please refer to the documentation or contact the development team.