const { Sequelize } = require('sequelize');
const path = require('path');

// Initialize Sequelize with SQLite
const sequelize = new Sequelize({
  dialect: 'sqlite',
  storage: path.join(__dirname, 'database.sqlite'),
  logging: console.log
});

async function checkTableSchema() {
  try {
    console.log('🔍 Checking actual database schema...\n');
    
    // Check bkashAgentAccounts table structure
    console.log('📊 bkashAgentAccounts table columns:');
    const [columns] = await sequelize.query(`
      PRAGMA table_info(bkashAgentAccounts);
    `);
    
    columns.forEach(col => {
      console.log(`  - ${col.name}: ${col.type} ${col.notnull ? 'NOT NULL' : ''} ${col.pk ? 'PRIMARY KEY' : ''}`);
    });
    
    // Check bkashTransactions table structure
    console.log('\n📊 bkashTransactions table columns:');
    const [transColumns] = await sequelize.query(`
      PRAGMA table_info(bkashTransactions);
    `);
    
    transColumns.forEach(col => {
      console.log(`  - ${col.name}: ${col.type} ${col.notnull ? 'NOT NULL' : ''} ${col.pk ? 'PRIMARY KEY' : ''}`);
    });
    
    // Try a simple query on bkashAgentAccounts
    console.log('\n🔍 Testing simple query...');
    const [results] = await sequelize.query(`
      SELECT * FROM bkashAgentAccounts LIMIT 1;
    `);
    
    if (results.length > 0) {
      console.log('✅ Sample record:', results[0]);
    } else {
      console.log('📝 No records found in bkashAgentAccounts');
    }
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    await sequelize.close();
  }
}

checkTableSchema();