const { Sequelize } = require('sequelize');
const path = require('path');

// Initialize Sequelize with SQLite
const sequelize = new Sequelize({
  dialect: 'sqlite',
  storage: path.join(__dirname, 'database.sqlite'),
  logging: console.log
});

async function fixBkashAgentSchema() {
  try {
    console.log('🔧 Fixing bkashAgentAccounts table schema...\n');
    
    // Check current columns
    console.log('📊 Current bkashAgentAccounts columns:');
    const [currentColumns] = await sequelize.query(`
      PRAGMA table_info(bkashAgentAccounts);
    `);
    
    const columnNames = currentColumns.map(col => col.name);
    console.log('Current columns:', columnNames);
    
    // Add missing columns if they don't exist
    if (!columnNames.includes('b2bSend')) {
      console.log('\n➕ Adding b2bSend column...');
      await sequelize.query(`
        ALTER TABLE bkashAgentAccounts 
        ADD COLUMN b2bSend DECIMAL(12,2) NOT NULL DEFAULT 0.00;
      `);
      console.log('✅ b2bSend column added');
    } else {
      console.log('✅ b2bSend column already exists');
    }
    
    if (!columnNames.includes('b2bReceived')) {
      console.log('\n➕ Adding b2bReceived column...');
      await sequelize.query(`
        ALTER TABLE bkashAgentAccounts 
        ADD COLUMN b2bReceived DECIMAL(12,2) NOT NULL DEFAULT 0.00;
      `);
      console.log('✅ b2bReceived column added');
    } else {
      console.log('✅ b2bReceived column already exists');
    }
    
    if (!columnNames.includes('amountReceived')) {
      console.log('\n➕ Adding amountReceived column...');
      await sequelize.query(`
        ALTER TABLE bkashAgentAccounts 
        ADD COLUMN amountReceived DECIMAL(12,2) NOT NULL DEFAULT 0.00;
      `);
      console.log('✅ amountReceived column added');
    } else {
      console.log('✅ amountReceived column already exists');
    }
    
    if (!columnNames.includes('bkashAccountNumberId')) {
      console.log('\n➕ Adding bkashAccountNumberId column...');
      await sequelize.query(`
        ALTER TABLE bkashAgentAccounts 
        ADD COLUMN bkashAccountNumberId INTEGER;
      `);
      console.log('✅ bkashAccountNumberId column added');
    } else {
      console.log('✅ bkashAccountNumberId column already exists');
    }
    
    // Verify the changes
    console.log('\n📊 Updated bkashAgentAccounts columns:');
    const [updatedColumns] = await sequelize.query(`
      PRAGMA table_info(bkashAgentAccounts);
    `);
    
    updatedColumns.forEach(col => {
      console.log(`  - ${col.name}: ${col.type} ${col.notnull ? 'NOT NULL' : ''} ${col.pk ? 'PRIMARY KEY' : ''}`);
    });
    
    console.log('\n✅ bkashAgentAccounts schema fixed!');
    
  } catch (error) {
    console.error('❌ Error:', error.message);
  } finally {
    await sequelize.close();
  }
}

fixBkashAgentSchema();