module.exports = (sequelize, Sequelize) => {
  const BkashPersonalAccount = sequelize.define("bkashPersonalAccount", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      unique: true,
      defaultValue: Sequelize.literal('CURRENT_DATE')
    },
    openingBalance: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Personal Bkash balance at start of day"
    },
    closingBalance: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: true,
      defaultValue: null,
      comment: "Personal Bkash balance at end of day"
    },
    totalSent: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total amount sent during the day"
    },
    totalReceived: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total amount received during the day"
    },
    netChange: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: true,
      defaultValue: null,
      comment: "Auto-calculated: Closing - Opening"
    },
    notes: {
      type: Sequelize.TEXT,
      allowNull: true,
      comment: "Additional notes for the day"
    },
    isCompleted: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
      comment: "Whether the day is completed (closing balance entered)"
    }
  }, {
    indexes: [
      {
        unique: true,
        fields: ['date']
      }
    ],
    hooks: {
      beforeSave: (instance) => {
        // Auto-calculate net change if closing balance is set
        if (instance.closingBalance !== null) {
          instance.netChange = parseFloat(instance.closingBalance) - parseFloat(instance.openingBalance);
          instance.isCompleted = true;
        }
      }
    }
  });

  return BkashPersonalAccount;
};