module.exports = (sequelize, Sequelize) => {
  const Customer = sequelize.define("customer", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    name: {
      type: Sequelize.STRING,
      allowNull: false
    },
    email: {
      type: Sequelize.STRING,
      unique: true
    },
    phone: {
      type: Sequelize.STRING,
      allowNull: false
    },
    address: {
      type: Sequelize.TEXT
    },
    dueBalance: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0.00,
      allowNull: false
    },
    creditLimit: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0.00
    },
    totalPurchases: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0.00
    },
    lastPurchaseDate: {
      type: Sequelize.DATE
    },
    notes: {
      type: Sequelize.TEXT
    },
    isActive: {
      type: Sequelize.BOOLEAN,
      defaultValue: true
    }
  });

  return Customer;
};