module.exports = (sequelize, Sequelize) => {
  const Expense = sequelize.define("expense", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    description: {
      type: Sequelize.STRING,
      allowNull: false
    },
    amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    category: {
      type: Sequelize.STRING,
      allowNull: false
    },
    paymentMethod: {
      type: Sequelize.ENUM('cash', 'bank', 'mobile'),
      defaultValue: 'cash'
    },
    notes: {
      type: Sequelize.TEXT
    },
    expenseDate: {
      type: Sequelize.DATE,
      defaultValue: Sequelize.NOW
    }
  });

  return Expense;
};