module.exports = (sequelize, Sequelize) => {
  const MobileRechargeAccount = sequelize.define("mobileRechargeAccount", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_DATE')
    },
    operator: {
      type: Sequelize.ENUM('grameenphone', 'banglalink', 'robi'),
      allowNull: false,
      comment: "Mobile operator name"
    },
    openingBalance: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Operator balance at start of day"
    },
    closingBalance: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: true,
      defaultValue: null,
      comment: "Operator balance at end of day"
    },
    totalRecharge: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total recharge amount during the day"
    },
    totalCommission: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total commission earned during the day"
    },
    commissionRate: {
      type: Sequelize.DECIMAL(5, 2),
      allowNull: false,
      defaultValue: 2.80,
      comment: "Commission rate percentage (e.g., 2.80 for 2.8%)"
    },
    totalSrPay: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total SR pay amount during the day"
    },
    totalMinutesCard: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total minutes card amount during the day"
    },
    totalMbCard: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Total MB card amount during the day"
    },
    totalSimQuantity: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "Total SIM cards sold during the day"
    },
    netChange: {
      type: Sequelize.DECIMAL(12, 2),
      allowNull: true,
      defaultValue: null,
      comment: "Auto-calculated: Closing - Opening"
    },
    notes: {
      type: Sequelize.TEXT,
      allowNull: true,
      comment: "Additional notes for the day"
    },
    isCompleted: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
      comment: "Whether the day is completed/closed"
    }
  }, {
    indexes: [
      {
        unique: true,
        fields: ['date', 'operator']
      }
    ]
  });

  return MobileRechargeAccount;
};