module.exports = (sequelize, Sequelize) => {
  const MobileRechargeTransaction = sequelize.define("mobileRechargeTransaction", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    date: {
      type: Sequelize.DATEONLY,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_DATE')
    },
    time: {
      type: Sequelize.TIME,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_TIME')
    },
    operator: {
      type: Sequelize.ENUM('grameenphone', 'banglalink', 'robi'),
      allowNull: false,
      comment: "Mobile operator name"
    },
    customerNumber: {
      type: Sequelize.STRING(15),
      allowNull: false,
      comment: "Customer mobile number"
    },
    rechargeAmount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      comment: "Recharge amount"
    },
    commission: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Commission earned from this transaction"
    },
    srPay: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "SR pay amount for this transaction"
    },
    minutesCard: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "Minutes card amount for this transaction"
    },
    mbCard: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00,
      comment: "MB card amount for this transaction"
    },
    simQuantity: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 0,
      comment: "Number of SIM cards sold in this transaction"
    },
    transactionType: {
      type: Sequelize.ENUM('recharge', 'flexiload', 'bundle'),
      allowNull: false,
      defaultValue: 'recharge',
      comment: "Type of recharge transaction"
    },
    reference: {
      type: Sequelize.STRING(100),
      allowNull: true,
      comment: "Transaction reference number"
    },
    notes: {
      type: Sequelize.TEXT,
      allowNull: true,
      comment: "Additional notes for the transaction"
    }
  });

  return MobileRechargeTransaction;
};