module.exports = (sequelize, Sequelize) => {
  const Product = sequelize.define("product", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    name: {
      type: Sequelize.STRING,
      allowNull: false
    },
    barcode: {
      type: Sequelize.STRING,
      unique: true
    },
    price: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    cost: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    stock: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    unit: {
      type: Sequelize.STRING
    },
    image: {
      type: Sequelize.STRING
    },
    description: {
      type: Sequelize.TEXT
    }
  });

  return Product;
};