module.exports = (sequelize, Sequelize) => {
  const Sale = sequelize.define("sale", {
    id: {
      type: Sequelize.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    totalAmount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false
    },
    discount: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0
    },
    tax: {
      type: Sequelize.DECIMAL(10, 2),
      defaultValue: 0
    },
    paymentMethod: {
      type: Sequelize.ENUM('cash', 'bank', 'mobile'),
      defaultValue: 'cash'
    },
    status: {
      type: Sequelize.ENUM('pending', 'completed', 'cancelled'),
      defaultValue: 'completed'
    },
    notes: {
      type: Sequelize.TEXT
    },
    receiptNumber: {
      type: Sequelize.STRING,
      unique: true
    }
  });

  return Sale;
};