const express = require('express');
const router = express.Router();
const agents = require("../controllers/agent.controller.js");
const { verifyToken, isManagerOrAdmin } = require("../middleware/auth.middleware");

// Apply middleware to all routes
router.use(verifyToken);

// Create a new Agent
router.post("/", isManagerOrAdmin, agents.create);

// Retrieve all Agents
router.get("/", agents.findAll);

// Retrieve a single Agent with id
router.get("/:id", agents.findOne);

// Update an Agent with id
router.put("/:id", isManagerOrAdmin, agents.update);

// Delete an Agent with id
router.delete("/:id", isManagerOrAdmin, agents.delete);

// Get agent payments
router.get("/:id/payments", agents.getPayments);

// Add a payment for an agent
router.post("/:id/payments", isManagerOrAdmin, agents.addPayment);

module.exports = router;