module.exports = app => {
  const bkashAgent = require("../controllers/bkashAgent.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware");

  var router = require("express").Router();

  // Create or update agent account
  router.post("/", verifyToken, bkashAgent.createOrUpdate);

  // Retrieve all agent accounts
  router.get("/", verifyToken, bkashAgent.findAll);

  // Retrieve today's agent account
  router.get("/today", verifyToken, bkashAgent.findToday);

  // Retrieve summary statistics
  router.get("/summary", verifyToken, bkashAgent.getSummary);

  // Retrieve agent account by date
  router.get("/:date", verifyToken, bkashAgent.findByDate);

  // Close day (update closing balance)
  router.put("/close", verifyToken, bkashAgent.closeDay);

  // Delete agent account by date
  router.delete("/:date", verifyToken, bkashAgent.delete);

  app.use('/api/bkash-agent', router);
};