module.exports = app => {
  const bkashReports = require("../controllers/bkashReports.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware");

  var router = require("express").Router();

  // Get daily report
  router.get("/daily/:date?", verifyToken, bkashReports.getDailyReport);

  // Get weekly report
  router.get("/weekly", verifyToken, bkashReports.getWeeklyReport);

  // Get monthly report
  router.get("/monthly", verifyToken, bkashReports.getMonthlyReport);

  // Get comparison report (Bkash vs Sales)
  router.get("/comparison", verifyToken, bkashReports.getComparisonReport);

  app.use('/api/bkash-reports', router);
};