const express = require('express');
const router = express.Router();
const {
  getTodayReconciliation,
  updateReconciliation,
  getReconciliationByDate,
  getReconciliationsByDateRange,
  getWeeklyReport,
  getMonthlyReport,
  deleteReconciliation
} = require('../controllers/cashReconciliation.controller');
const { verifyToken } = require('../middleware/auth.middleware');

// Apply authentication middleware to all routes
router.use(verifyToken);

// Get today's reconciliation
router.get('/today', getTodayReconciliation);

// Get reconciliations by date range
router.get('/range', getReconciliationsByDateRange);

// Get weekly report
router.get('/reports/weekly', getWeeklyReport);

// Get monthly report
router.get('/reports/monthly', getMonthlyReport);

// Get reconciliation by specific date
router.get('/:date', getReconciliationByDate);

// Update reconciliation for specific date
router.put('/:date', updateReconciliation);

// Delete reconciliation for specific date
router.delete('/:date', deleteReconciliation);

module.exports = router;