const express = require('express');
const router = express.Router();
const customers = require("../controllers/customer.controller.js");
const { verifyToken, isManagerOrAdmin } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Create a new Customer
router.post("/", customers.create);

// Retrieve all Customers
router.get("/", customers.findAll);

// Retrieve all active Customers
router.get("/active", customers.findAllActive);

// Retrieve customers with due balance
router.get("/due", customers.findWithDue);

// Retrieve a single Customer with id
router.get("/:id", customers.findOne);

// Get customer purchase history
router.get("/:id/history", customers.getPurchaseHistory);

// Update a Customer with id
router.put("/:id", customers.update);

// Update customer due balance
router.patch("/:id/due", customers.updateDueBalance);

// Delete a Customer with id (only managers and admins)
router.delete("/:id", isManagerOrAdmin, customers.delete);

// Delete all Customers (only managers and admins)
router.delete("/", isManagerOrAdmin, customers.deleteAll);

module.exports = router;