const express = require('express');
const router = express.Router();
const expenses = require("../controllers/expense.controller.js");
const { verifyToken, isManagerOrAdmin } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Create a new Expense
router.post("/", expenses.create);

// Retrieve all Expenses with filtering
router.get("/", expenses.findAll);

// Get expense summary for dashboard
router.get("/summary", expenses.getSummary);

// Get daily expense summary
router.get("/daily-summary", expenses.getDailySummary);

// Get expense categories
router.get("/categories", expenses.getCategories);

// Retrieve a single Expense with id
router.get("/:id", expenses.findOne);

// Update an Expense with id
router.put("/:id", expenses.update);

// Delete an Expense with id
router.delete("/:id", expenses.delete);

// Delete all Expenses (only managers and admins)
router.delete("/", isManagerOrAdmin, expenses.deleteAll);

module.exports = router;