module.exports = app => {
  const mobileRecharge = require("../controllers/mobileRecharge.controller.js");
  const { verifyToken } = require("../middleware/auth.middleware");

  var router = require("express").Router();

  // Get summary for all operators
  router.get("/summary", verifyToken, mobileRecharge.getSummary);

  // Get dashboard summary for all operators
  router.get("/dashboard-summary", verifyToken, mobileRecharge.getDashboardSummary);

  // Get today's account for a specific operator
  router.get("/:operator/today", verifyToken, mobileRecharge.getTodayAccount);

  // Get transactions for a specific operator (must come before /:operator/:date)
  router.get("/:operator/transactions", verifyToken, mobileRecharge.getTransactions);

  // Get account history for an operator (must come before /:operator/:date)
  router.get("/:operator/history", verifyToken, mobileRecharge.getAccountHistory);

  // Get daily balance summary (must come before /:operator/:date)
  router.get("/:operator/daily-summary", verifyToken, mobileRecharge.getDailySummary);

  // Update account for a specific operator
  router.put("/:operator", verifyToken, mobileRecharge.updateAccount);

  // Add a transaction for a specific operator
  router.post("/:operator/transaction", verifyToken, mobileRecharge.addTransaction);

  // Set daily opening balance
  router.post("/:operator/open-day", verifyToken, mobileRecharge.openDay);

  // Close daily balance
  router.post("/:operator/close-day", verifyToken, mobileRecharge.closeDay);

  // Get account by date and operator (must come after all specific routes)
  router.get("/:operator/:date", verifyToken, mobileRecharge.getAccountByDate);

  // Delete a transaction
  router.delete("/transaction/:id", verifyToken, mobileRecharge.deleteTransaction);

  app.use('/api/mobile-recharge', router);
};