const express = require('express');
const router = express.Router();
const reportsController = require('../controllers/reports.controller');
const { verifyToken, isManagerOrAdmin } = require('../middleware/auth.middleware');

// Apply authentication middleware to all routes
router.use(verifyToken);
router.use(isManagerOrAdmin);

// Reports routes
router.get('/sales-summary', reportsController.getSalesSummary);
router.get('/top-products', reportsController.getTopProducts);
router.get('/inventory-status', reportsController.getInventoryStatus);
router.get('/user-performance', reportsController.getUserPerformance);
router.get('/agent-balances', reportsController.getAgentBalances);
router.get('/payment-summary', reportsController.getPaymentSummary);

module.exports = router;