const express = require('express');
const router = express.Router();
const sales = require("../controllers/sales.controller.js");
const { verifyToken } = require("../middleware/auth.middleware");

// Apply authentication middleware to all routes
router.use(verifyToken);

// Create a new Sale
router.post("/", sales.create);

// Retrieve all Sales
router.get("/", sales.findAll);

// Get sales summary for dashboard
router.get("/summary", sales.getSummary);

// Retrieve a single Sale with id
router.get("/:id", sales.findOne);

module.exports = router;