const express = require('express');
const router = express.Router();
const smsController = require('../controllers/sms.controller');

// POST /api/sms/receive - Receive SMS and process recharge
router.post('/receive', smsController.receiveSMS);

// GET /api/sms/history - Get SMS processing history
router.get('/history', smsController.getSMSHistory);

// POST /api/sms/test - Test SMS parsing (for development)
router.post('/test', smsController.testSMSParsing);

module.exports = router;