const db = require('../models');
const BkashAccountNumber = db.bkashAccountNumbers;

async function addSampleAgents() {
  try {
    // Check if primary agent already exists
    const existingPrimary = await BkashAccountNumber.findOne({
      where: { 
        accountType: 'agent',
        isPrimary: true,
        isActive: true
      }
    });

    // Add sample agent numbers
    const agents = [
      {
        accountType: 'agent',
        accountNumber: '01712345678',
        accountName: 'Main Agent Account',
        isActive: true,
        isPrimary: !existingPrimary // Only set as primary if no primary exists
      },
      {
        accountType: 'agent',
        accountNumber: '01798765432',
        accountName: 'Secondary Agent Account',
        isActive: true,
        isPrimary: false
      },
      {
        accountType: 'agent',
        accountNumber: '01655443322',
        accountName: 'Backup Agent Account',
        isActive: true,
        isPrimary: false
      }
    ];

    for (const agent of agents) {
      const existingAgent = await BkashAccountNumber.findOne({
        where: { accountNumber: agent.accountNumber }
      });

      if (!existingAgent) {
        await BkashAccountNumber.create(agent);
        console.log(`Created agent: ${agent.accountNumber} - ${agent.accountName}`);
      } else {
        console.log(`Agent already exists: ${agent.accountNumber}`);
      }
    }

    console.log('Sample agents added successfully!');
  } catch (error) {
    console.error('Error adding sample agents:', error);
  }
}

addSampleAgents();