const http = require('http');

// Test authentication flow
async function testAuthFlow() {
  console.log('Testing authentication flow...\n');
  
  // Step 1: Try to login
  const loginData = JSON.stringify({
    email: 'admin@example.com',
    password: 'admin123'
  });

  const loginOptions = {
    hostname: 'localhost',
    port: 5000,
    path: '/api/auth/login',
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Content-Length': Buffer.byteLength(loginData)
    }
  };

  return new Promise((resolve, reject) => {
    const req = http.request(loginOptions, (res) => {
      let data = '';
      
      res.on('data', (chunk) => {
        data += chunk;
      });
      
      res.on('end', () => {
        console.log(`Login Response Status: ${res.statusCode}`);
        
        if (res.statusCode === 200) {
          try {
            const response = JSON.parse(data);
            console.log('Login successful!');
            console.log('Token received:', response.token ? 'Yes' : 'No');
            
            if (response.token) {
              // Step 2: Test Bkash API with valid token
              testBkashWithToken(response.token);
            }
          } catch (error) {
            console.log('Error parsing login response:', error.message);
          }
        } else {
          console.log('Login failed:', data);
        }
        resolve();
      });
    });

    req.on('error', (error) => {
      console.log('Login request error:', error.message);
      resolve();
    });

    req.write(loginData);
    req.end();
  });
}

function testBkashWithToken(token) {
  console.log('\nTesting Bkash API with valid token...');
  
  const options = {
    hostname: 'localhost',
    port: 5000,
    path: '/api/bkash-agent/today',
    method: 'GET',
    headers: {
      'Authorization': `Bearer ${token}`
    }
  };

  const req = http.request(options, (res) => {
    let data = '';
    
    res.on('data', (chunk) => {
      data += chunk;
    });
    
    res.on('end', () => {
      console.log(`Bkash API Response Status: ${res.statusCode}`);
      
      if (res.statusCode === 200) {
        console.log('✅ Bkash API working correctly with valid token!');
        try {
          const response = JSON.parse(data);
          console.log('Account data received:', response.account ? 'Yes' : 'No');
        } catch (error) {
          console.log('Response data:', data);
        }
      } else {
        console.log('❌ Bkash API failed:', data);
      }
    });
  });

  req.on('error', (error) => {
    console.log('Bkash API request error:', error.message);
  });

  req.end();
}

// Run the test
testAuthFlow().then(() => {
  console.log('\nTest completed!');
});