// Simple test script to verify API endpoints
const axios = require('axios');
const baseURL = 'http://localhost:5000/api';

// Test function
async function testEndpoints() {
  console.log('Starting API tests...');
  
  try {
    // Test products API
    console.log('\n--- Testing Products API ---');
    const productsResponse = await axios.get(`${baseURL}/products`);
    console.log(`GET /products - Status: ${productsResponse.status}`);
    console.log(`Found ${productsResponse.data.data.length} products`);
    
    // Test categories API
    console.log('\n--- Testing Categories API ---');
    const categoriesResponse = await axios.get(`${baseURL}/categories`);
    console.log(`GET /categories - Status: ${categoriesResponse.status}`);
    console.log(`Found ${categoriesResponse.data.data.length} categories`);
    
    // Test inventory API
    console.log('\n--- Testing Inventory API ---');
    const inventoryResponse = await axios.get(`${baseURL}/inventory/status`);
    console.log(`GET /inventory/status - Status: ${inventoryResponse.status}`);
    
    // Test reports API
    console.log('\n--- Testing Reports API ---');
    const reportsResponse = await axios.get(`${baseURL}/reports/sales-summary`);
    console.log(`GET /reports/sales-summary - Status: ${reportsResponse.status}`);
    
    console.log('\nAll tests completed successfully!');
  } catch (error) {
    console.error('Test failed:', error.message);
    if (error.response) {
      console.error(`Status: ${error.response.status}`);
      console.error('Response:', error.response.data);
    }
  }
}

// Run tests
testEndpoints();