import React, { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { Container } from 'react-bootstrap';
import { useAuth } from '../../contexts/AuthContext';
import Sidebar from './Sidebar';
import Header from './Header';
import './MainLayout.css';

const MainLayout = ({ children }) => {
  const navigate = useNavigate();
  const { logout } = useAuth();
  const [sidebarOpen, setSidebarOpen] = useState(true);

  const handleLogout = () => {
    logout();
    navigate('/login');
  };

  const toggleSidebar = () => {
    setSidebarOpen(!sidebarOpen);
  };

  return (
    <div className="main-layout">
      <Sidebar isOpen={sidebarOpen} />
      <div className={`content-area ${sidebarOpen ? 'sidebar-open' : 'sidebar-closed'}`}>
        <Header onLogout={handleLogout} toggleSidebar={toggleSidebar} />
        <Container fluid className="main-content">
          {children}
        </Container>
      </div>
    </div>
  );
};

export default MainLayout;