import React, { useState, useEffect } from 'react';
import { Container, Row, Col, Card, Tabs, Tab, Alert } from 'react-bootstrap';
import MobileRechargeOperator from './MobileRechargeOperator';
import DSODeliveries from './DSODeliveries';
import DSOReports from './DSOReports';
import './MobileRecharge.css';

const MobileRecharge = () => {
  const [activeTab, setActiveTab] = useState('grameenphone');
  const [alert, setAlert] = useState({ show: false, message: '', variant: 'success' });

  const showAlert = (message, variant = 'success') => {
    setAlert({ show: true, message, variant });
    setTimeout(() => setAlert({ show: false, message: '', variant: 'success' }), 3000);
  };

  const operators = [
    {
      key: 'grameenphone',
      name: 'Grameenphone',
      icon: 'fas fa-mobile-alt',
      color: '#00A651'
    },
    {
      key: 'banglalink',
      name: 'Banglalink',
      icon: 'fas fa-mobile-alt',
      color: '#FF6600'
    },
    {
      key: 'robi',
      name: 'Robi',
      icon: 'fas fa-mobile-alt',
      color: '#E60012'
    }
  ];

  return (
    <Container fluid className="mobile-recharge-container">
      <Row className="mb-4">
        <Col>
          <h2 className="page-title">
            <i className="fas fa-mobile-alt me-2"></i>
            Mobile Recharge Management
          </h2>
          <p className="text-muted">Manage your mobile recharge accounts, transactions, and DSO operations</p>
        </Col>
      </Row>

      {alert.show && (
        <Row className="mb-3">
          <Col>
            <Alert variant={alert.variant} dismissible onClose={() => setAlert({ show: false, message: '', variant: 'success' })}>
              {alert.message}
            </Alert>
          </Col>
        </Row>
      )}

      <Row>
        <Col>
          <Card className="shadow-sm">
            <Card.Body>
              <Tabs
                activeKey={activeTab}
                onSelect={(k) => setActiveTab(k)}
                className="mb-3 custom-tabs"
              >
                {operators.map(operator => (
                  <Tab 
                    key={operator.key}
                    eventKey={operator.key} 
                    title={
                      <span style={{ color: activeTab === operator.key ? operator.color : '#6c757d' }}>
                        <i className={`${operator.icon} me-2`}></i>
                        {operator.name}
                      </span>
                    }
                  >
                    <MobileRechargeOperator 
                      operator={operator.key}
                      operatorName={operator.name}
                      operatorColor={operator.color}
                      showAlert={showAlert} 
                    />
                  </Tab>
                ))}
                
                {/* DSO Deliveries & Allocations Tab */}
                <Tab 
                  eventKey="dso-deliveries" 
                  title={
                    <span style={{ color: activeTab === 'dso-deliveries' ? '#007bff' : '#6c757d' }}>
                      <i className="fas fa-truck me-2"></i>
                      DSO Deliveries
                    </span>
                  }
                >
                  <DSODeliveries showAlert={showAlert} />
                </Tab>

                {/* DSO Reports Tab */}
                <Tab 
                  eventKey="dso-reports" 
                  title={
                    <span style={{ color: activeTab === 'dso-reports' ? '#17a2b8' : '#6c757d' }}>
                      <i className="fas fa-chart-line me-2"></i>
                      DSO Reports
                    </span>
                  }
                >
                  <DSOReports showAlert={showAlert} />
                </Tab>
              </Tabs>
            </Card.Body>
          </Card>
        </Col>
      </Row>
    </Container>
  );
};

export default MobileRecharge;