// Simple test to check API connectivity
import axios from 'axios';

const testAPI = async () => {
  try {
    console.log('Testing API connectivity...');
    
    // Test basic connectivity
    const response = await axios.get('http://localhost:5000/api/auth/test');
    console.log('API Test Response:', response.data);
    
  } catch (error) {
    console.error('API Test Error:', error);
    console.error('Error details:', {
      message: error.message,
      code: error.code,
      response: error.response?.data,
      status: error.response?.status
    });
  }
};

// Test login specifically
const testLogin = async () => {
  try {
    console.log('Testing login API...');
    
    const response = await axios.post('http://localhost:5000/api/auth/login', {
      email: 'admin@example.com',
      password: 'admin123'
    });
    
    console.log('Login Test Success:', response.data);
    
  } catch (error) {
    console.error('Login Test Error:', error);
    console.error('Error details:', {
      message: error.message,
      code: error.code,
      response: error.response?.data,
      status: error.response?.status
    });
  }
};

export { testAPI, testLogin };